% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_sample.R
\name{optimal_sample}
\alias{optimal_sample}
\title{Justify your alpha level by minimizing or balancing Type 1 and Type 2 error rates.}
\usage{
optimal_sample(
  power_function,
  errorgoal = 0.05,
  costT1T2 = 1,
  priorH1H0 = 1,
  error = "minimize",
  printplot = FALSE
)
}
\arguments{
\item{power_function}{Function that outputs the power, calculated with an analytic function.}

\item{errorgoal}{Desired weighted combined error rate}

\item{costT1T2}{Relative cost of Type 1 errors vs. Type 2 errors.}

\item{priorH1H0}{How much more likely a-priori is H1 than H0?}

\item{error}{Either "minimize" to minimize error rates, or "balance" to balance error rates.}

\item{printplot}{Print a plot to illustrate the alpha level calculation. This will make the function considerably slower.}
}
\value{
Returns a list of the following
alpha = alpha or Type 1 error that minimizes or balances combined error rates,
beta = beta or Type 2 error that minimizes or balances combined error rates,
errorrate = weighted combined error rate,
objective = value that is the result of the minimization, either 0 (for balance) or the combined weighted error rates,
samplesize = the desired samplesize.
plot = plot of alpha, beta, and error rate as a function of samplesize (only if printplot = TRUE)
}
\description{
Justify your alpha level by minimizing or balancing Type 1 and Type 2 error rates.
}
\section{References}{

Maier & Lakens (2021). Justify Your Alpha: A Primer on Two Practical Approaches
}

\examples{
## Optimize power for a independent t-test, smallest effect of interest
## d = 0.5, desired weighted combined error rate = 5\%
res <- optimal_sample(power_function = "pwr::pwr.t.test(d = 0.5, n = sample_n, sig.level = x,
type = 'two.sample', alternative = 'two.sided')$power",errorgoal = 0.05)
res$alpha
res$beta
res$errorrate
res$samplesize

}
