% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.simpsr}
\alias{predict.simpsr}
\title{Predict function for \code{sim_psr}}
\usage{
\method{predict}{simpsr}(object, ..., X_pred)
}
\arguments{
\item{object}{an object using \code{sim_psr}.}

\item{...}{other parameters.}

\item{X_pred}{a matrix of arbitrary signals with \code{ncol(X_pred) = length(x_index)} locations for
desired prediction.}
}
\value{
\item{pred}{the estimated (inverse single-index) mean for the signals in \code{X_pred}.}
}
\description{
Prediction function which returns single-index
inverse link linear predictions at arbitrary data locations (using
\code{sim_psr} with \code{class simpsr}).
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40])
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]

pords <- c(2, 2)
nsegs <- c(27, 7)
bdegs = c(3, 3)
lambdas <- c(1e-6, .1)
max_iter <- 100

# Single-index model
fit <- sim_psr(y, dX, diindex, nsegs, bdegs, lambdas, pords,
             max_iter)
predict(fit, X_pred = dX)

}
\references{
Eilers, P.H.C., B. Li, B.D. Marx (2009).
Multivariate calibration with single-index signal regression,
\emph{Chemometrics and Intellegent Laboratory Systems}, 96(2), 196-202.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
