% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_issues.R
\name{append}
\alias{append}
\alias{append.IssuesTB}
\title{Vector Merging}
\usage{
append(x, values, after = length(x))

\method{append}{IssuesTB}(x, values, after)
}
\arguments{
\item{x}{the vector the values are to be appended to.}

\item{values}{a \code{IssueTB} or a \code{IssuesTB} object.}

\item{after}{a subscript, after which the values are to be appended.}
}
\value{
A vector containing the values in \code{x} with the elements of
  \code{values} appended after the specified element of \code{x}.
}
\description{
Add elements to a vector.
}
\examples{
append(1:5, 0:1, after = 3)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
