% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Main.R
\name{Concordance}
\alias{Concordance}
\title{Concordance}
\usage{
Concordance(actuals, predictedScores)
}
\arguments{
\item{actuals}{The actual binary flags for the response variable. It can take a numeric vector containing values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{predictedScores}{The prediction probability scores for each observation. If your classification model gives the 1/0 predcitions, convert it to a numeric vector of 1's and 0's.}
}
\value{
a list containing percentage of concordant pairs, percentage discordant pairs, percentage ties and No. of pairs.
\itemize{
  \item Concordance The total proportion of pairs in concordance. A pair is said to be concordant when the predicted score of 'Good' (Event) is greater than that of the 'Bad'(Non-event)
  \item Discordance The total proportion of pairs that are discordant.
  \item Tied The proportion of pairs for which scores are tied.
  \item Pairs The total possible combinations of 'Good-Bad' pairs based on actual response (1/0) labels.
}
}
\description{
Calculate concordance and discordance percentages for a logit model
}
\details{
Calculate the percentage of concordant and discordant pairs for a given logit model.
}
\examples{
data('ActualsAndScores')
Concordance(actuals=ActualsAndScores$Actuals, predictedScores=ActualsAndScores$PredictedScores)
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

