% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportIncidencePrevalenceResults.R
\name{exportIncidencePrevalenceResults}
\alias{exportIncidencePrevalenceResults}
\title{Export IncidencePrevalence results}
\usage{
exportIncidencePrevalenceResults(result, zipName, outputFolder)
}
\arguments{
\item{result}{IncidencePrevalence results from gatherResults()}

\item{zipName}{name to give zip folder}

\item{outputFolder}{directory to save zip folder containing results as a set
of CSV files}
}
\value{
zip folder of results saved in the outputFolder
}
\description{
Export IncidencePrevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm$denominator <- generateDenominatorCohortSet(
  cdm = cdm,
  startDate = as.Date("2008-01-01"),
  endDate = as.Date("2018-01-01")
)
prev <- estimatePointPrevalence(
cdm = cdm,
denominatorTable = "denominator",
outcomeTable = "outcome"
)
 results <- gatherIncidencePrevalenceResults(cdm = cdm, resultList=list(prev))
 exportIncidencePrevalenceResults(result=results, zipName="test",
                                  outputFolder=tempdir())
}
}
