/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

public class Timer {
    private long baseTime;
    private long elapsedTime;

    public Timer() {
        this.reset();
    }

    public Timer display() {
        System.out.println(this);
        return this;
    }

    public double elapsedTime() {
        return this.seconds();
    }

    public double millis() {
        long l = this.elapsedTime;
        if (this.baseTime != 0L) {
            l += System.nanoTime() - this.baseTime;
        }
        return (double)l / 1000000.0;
    }

    public long nanos() {
        long l = this.elapsedTime;
        if (this.baseTime != 0L) {
            l += System.nanoTime() - this.baseTime;
        }
        return l;
    }

    public Timer minus(Timer timer) {
        Timer timer2 = new Timer();
        timer2.elapsedTime = this.nanos() - timer.nanos();
        return timer2;
    }

    public double minutes() {
        return this.seconds() / 60.0;
    }

    public Timer plus(Timer timer) {
        Timer timer2 = new Timer();
        timer2.elapsedTime = this.nanos() + timer.nanos();
        return timer2;
    }

    public Timer reset() {
        this.elapsedTime = 0L;
        this.baseTime = 0L;
        return this;
    }

    public double seconds() {
        return (double)this.nanos() / 1.0E9;
    }

    public Timer start() {
        this.baseTime = System.nanoTime();
        return this;
    }

    public Timer stop() {
        if (this.baseTime != 0L) {
            this.elapsedTime += System.nanoTime() - this.baseTime;
        }
        this.baseTime = 0L;
        return this;
    }

    public static void test(int n) {
        int n2;
        Timer timer = new Timer().start();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            ++n3;
        }
        timer.stop();
        timer.display();
        System.out.println("I finished the test using " + timer);
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            ++n3;
        }
        timer.start();
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            ++n3;
        }
        timer.stop().display();
        timer.reset();
        timer.start();
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            ++n3;
        }
        timer.stop().display();
    }

    public String toString() {
        return "Time=" + String.format("%.4f", this.elapsedTime()) + " secs";
    }
}

