% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.report.R
\name{ISRaD.report}
\alias{ISRaD.report}
\title{ISRaD.report}
\usage{
ISRaD.report(database, report)
}
\arguments{
\item{database}{ISRaD data object}

\item{report}{Parameter to define which type of report you want. The default is "count.all" other options include "entry.stats", "count.frc", or "site.map".}
}
\description{
Generate basic summary reports of ISRaD data
}
\details{
Wrapper for the simple reporting functions ISRaD.rep.count.all, ISRaD.rep.count.frc, ISRaD.rep.entry.stats, ISRaD.rep.site.map
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Report metadata statistics
ISRaD.report(database, report = "entry.stats")
# Report summary statistics for all levels of the database
ISRaD.report(database, report = "count.all")
# Generate a map of all ISRaD sites
ISRaD.report(database, report = "site.map")
}

}
