% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric.R
\name{cgeneric}
\alias{cgeneric}
\title{Defines a GMRF model to be used with the
C interface for \code{INLA} as a latent model.}
\usage{
cgeneric(model, ...)
}
\arguments{
\item{model}{object class for what a \code{cgeneric} method exists.
if it is a character, a specific function will be called,
for example cgeneric("iid", ...") calls cgeneric_iid(...)}

\item{...}{additional arguments passed on to methods}
}
\value{
named list of \code{cgeneric} class containing
the named list \code{f} that contain \code{model} (a character
always equal to \code{cgeneric}), \code{n} (integer)
and \code{cgeneric} as a named list that contains the
data needed to define the model. Each element on
...$f$cgeneric is also a named list containing
\code{ints}, \code{doubles}, \code{characters}, \code{matrices}
and \code{smatrices}.
}
\description{
This prepare data for the C type to organize data needed
for building latent models which are characterized
from given model parameters \eqn{\theta} and the
the following model elements.
\itemize{
\item \code{graph} to define the non-zero precision matrix pattern.
only the upper triangle including the diagonal is needed.
The order should be by line.
\item \code{Q} vector where the
\itemize{
\item first element (N) is the size of the matrix,
\item second element (M) is the number of non-zero
elements in the upper part (including) diagonal
\item the remaining (M) elements are the actual
precision (upper triangle plus diagonal) elements
whose order shall follow the graph definition.
}
\item \code{mu} the mean vector,
\item \code{initial} vector with
\itemize{
\item first element as the number of the parameters in the model
\item remaining elements should be the initials for the model parameters.
}
\item \code{log.norm.const} log of the normalizing constant.
\item \code{log.prior} log of the prior for the model parameters.
}

See details in \code{\link[INLA:cgeneric]{INLA::cgeneric()}}
}
\seealso{
\code{\link[INLA:cgeneric]{INLA::cgeneric()}} and \code{\link[=methods]{methods()}}
}
