% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinyFunctions.R
\name{interConfMatrix}
\alias{interConfMatrix}
\title{Interactive confusion matrix}
\usage{
interConfMatrix(list_models, model_function = NULL, data = NULL, y = NULL)
}
\arguments{
\item{list_models}{A list of one (or more) dataframes for each model whose performance is to be evaluated. Each dataframe should comprise of 2 columns with the first column indicating the class labels (0 or 1)
and the second column provding the raw predicted probabilities}

\item{model_function}{Models can be created interactively, if required. For this option to work, a model function
should be passed as an argument. The model function should take a formula as an argument, and return a
a dataframe as output (dataframe should comprise of 2 columns with the first column indicating the class labels (0 or 1)
and the second column provding the raw predicted probabilities) Please refer to the example section for more details}

\item{data}{The name of the data-set. The Independent Variable (IV) names, for interactive model building, is picked up from this data set}

\item{y}{The column name of the Dependent Variable (DV), for interactive model building}
}
\value{
This function will launch a ShinyApp.Input parameters (such as the probability threshold,
the "t" argument in the static version of this function) can be adjusted
through app widgets. The 'Run-Analysis' button in the app, will generate model performance
output basis selected input parameters

For interactive Model building, a model function, data set & the dependent variable name
should be passed as arguments. Interactive model building option
creates additional input widgets in the app. This includes -

A drop down to select independent variables (the names of the variables will be picked up from the data argument)

An input slider to include additional models (upto 4 additional models can be created). Each additional model
updates the original model created. For e.g. consider the dataset has 10 IVs: x1-x10. Original model
was created by selecting x1-x4 from the drop down list. If we need to create a second model, by including x5 and excluding x3 simply type,
"+ x5 - x3" in the input text box
}
\description{
Interactive version of the staticConfMat function
}
\examples{
# Without interactive model development
model_1 <- glm(Species ~ Sepal.Length,data=iris,family=binomial)
model_2 <- glm(Species ~ Sepal.Width, data=iris, family = binomial)
df1 <- data.frame(model_1$y,fitted(model_1))
df2 <- data.frame(model_2$y,fitted(model_2))
\dontrun{
#This will launch a Shiny App
interConfMatrix(list_models = list(df1,df2))}

# With interactive model development
glm_model <- function(formula) {
   glm_model <- glm(formula, data = iris, family = "binomial")
   out <- data.frame(glm_model$y, fitted(glm_model))
   out }
 \dontrun{
 #This will launch a Shiny App
 interConfMatrix(model_function=glm_model,data=iris,y="Species")}

}

