% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repcreate.R
\name{repcreate}
\alias{repcreate}
\title{Creation of Replicate Weights}
\usage{
repcreate(
  df,
  wt,
  jkzone,
  jkrep,
  repwtname,
  reps = NULL,
  method = c("TIMSS", "PIRLS", "ICILS", "ICCS")
)
}
\arguments{
\item{df}{a data frame.}

\item{wt}{a string specifying the name of the column (within \code{df}) with the
total weights.}

\item{jkzone}{a string specifying the name of the column in \code{df}
that contains the jackknife zone information.}

\item{jkrep}{a string specifying the name of the column in \code{df}
that contains the jackknife replicate information.}

\item{repwtname}{a string specifying the variable names for the
replicate weights.}

\item{reps}{an integer indicating the number of replications to be created.
If \code{NULL} the maximum number of zones will be used.}

\item{method}{a string indicating the name of the large-scale assessment
to determine the replication method to use. Available options are:
\code{"TIMSS"}, \code{"PIRLS"}, \code{"ICILS"},  and \code{"ICCS"}.}
}
\value{
a data frame.
}
\description{
Creates replicate weights given jackknife replicates and jackknife zones.
}
\examples{

head(repdata)

# Creation of replicate weights
RW <- repcreate(df = repdata, # the data frame with all the information
                 wt = "wt", # the total weights column name
                 jkzone = "jkzones", # the jkzones column name
                 jkrep = "jkrep", # the jkreps column name
                 repwtname = "REPWT", # the desired name for the rep weights
                 reps = 50, # the number of replications
                 method = "ICILS") # the name of the method aka the study name

head(RW)
}
