% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{CheckAndReturnIDMatrix}
\alias{CheckAndReturnIDMatrix}
\title{Check and return the ID mutation matrix}
\usage{
CheckAndReturnIDMatrix(
  annotated.vcf,
  discarded.variants,
  ID.mat,
  ID166.mat,
  return.annotated.vcf = FALSE
)
}
\arguments{
\item{annotated.vcf}{An annotated ID VCF with additional column
\code{ID.class} showing ID classification for each variant.}

\item{discarded.variants}{A \code{data.frame} which contains rows of ID
variants which are excluded in the analysis.}

\item{ID.mat}{The ID mutation count matrix.}

\item{ID166.mat}{The ID166 mutation count matrix.}

\item{return.annotated.vcf}{Whether to return \code{annotated.vcf}. Default is
FALSE.}
}
\description{
Check and return the ID mutation matrix
}
\section{Value}{
 A list of two 1-column ID matrices containing the mutation catalog
  information and the annotated VCF with ID categories information added. If
  some ID variants were excluded in the analysis, an additional element
  \code{discarded.variants} will appear in the return list.
}

\keyword{internal}
