% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnbinom_new.R
\name{rnbinom_new}
\alias{rnbinom_new}
\title{Random numbers for the negative binomial distribution.}
\usage{
rnbinom_new(n, size = NULL, prob = NULL, mu = NULL, sd = NULL, var = NULL)
}
\arguments{
\item{n}{number of observations.}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{mu}{alternative parametrization via mean.}

\item{sd}{alternative parametrization via standard deviation.}

\item{var}{alternative parametrization via variance.}
}
\value{
Random numbers for the negative binomial distribution
}
\description{
See \code{rnbinom}.
}
\details{
rnbinom_new returns random numbers for the negative binomial distribution
}
\examples{
\dontrun{
library("HelpersMG")
set.seed(1)
x <- rnbinom_new(n=1000, prob=6.25/(5+6.25), size=6.25)
mean(x)
sd(x)
set.seed(1)
x <- rnbinom_new(n=1000, mu=5, sd=3)
mean(x)
sd(x)
set.seed(1)
x <- rnbinom_new(n=1000, mu=5, var=3^2)
mean(x)
sd(x)
set.seed(1)
x <- rnbinom_new(n=1000, mu=5, size=6.25)
mean(x)
sd(x)
set.seed(1)
x <- rnbinom_new(n=1000, size=6.25, var=3^2)
mean(x)
sd(x)
set.seed(1)
x <- rnbinom_new(n=1000, prob=6.25/(5+6.25), var=3^2)
mean(x)
sd(x)
# Example of wrong parametrization
set.seed(1)
x <- rnbinom_new(n=1000, sd=3, var=3^2)
set.seed(1)
x <- rnbinom_new(n=1000, mu=10, var=3^2)
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
