#' logLik.cutter return log likelihood of a cutter fitted model
#' @title Return log likelihood of a cutter fitted model
#' @author Marc Girondot
#' @return Nothing
#' @param object A result file generated by cutter
#' @param ... Not used
#' @description Return log likelihood of a cutter fitted model.
#' @family Distributions
#' @examples
#' \dontrun{
#' # ___________________________________________________________________
#' # Test for similarity in gamma left censored distribution between two
#' # datasets
#' # ___________________________________________________________________
#' obc1 <- rgamma(100, scale=20, shape=2)
#' # Detection limit for sample 1 to 50
#' LDL <- 10
#' # remove the data below the detection limit
#' obc1[obc1<LDL] <- -Inf
#' obc2 <- rgamma(100, scale=10, shape=2)
#' # remove the data below the detection limit
#' obc2[obc2<LDL] <- -Inf
#' # search for the parameters the best fit these censored data
#' result1 <- cutter(observations=obc1, 
#'                            lower_detection_limit=LDL, 
#'                           cut_method="censored")
#' logLik(result1)
#' result2 <- cutter(observations=obc2, 
#'                            lower_detection_limit=LDL, 
#'                           cut_method="censored")
#' logLik(result2)
#' result_totl <- cutter(observations=c(obc1, obc2), 
#'                            lower_detection_limit=LDL, 
#'                           cut_method="censored")
#' logLik(result_totl)
#' compare_AICc(Separate=list(result1, result2), 
#'             Common=result_totl, factor.value=1)
#' compare_BIC(Separate=list(result1, result2), 
#'             Common=result_totl, factor.value=1) 
#' }
#' @method logLik cutter
#' @export


logLik.cutter <- function(object, ...) {

  x <- object$value

  attributes(x) <- list(nall=NULL, 
                        df=length(object$par), 
                        nobs=nrow(object$observations))
  return(x)
}

