% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.comparison.R
\name{data.comparison}
\alias{data.comparison}
\title{Data series comparison using Akaike weight}
\usage{
data.comparison(..., criterion = c("BIC", "AIC", "AICc"), var.equal = TRUE)
}
\arguments{
\item{...}{Series of data (at least two or data are in a table with series in different rows)}

\item{criterion}{Which criterion is used for model selection. can be AIC, AICc or BIC}

\item{var.equal}{Should the variances of all series being equal? Default TRUE}
}
\value{
The probability that a single proportion model is sufficient to explain the data
}
\description{
This function is used as a replacement of t.test() to not use p-value.
}
\details{
data.comparison compares series of data using Akaike weight.
}
\examples{
\dontrun{
library("HelpersMG")
A <- rnorm(100, 10, 2)
B <- rnorm(100, 11.1, 2)
data.comparison(A, B, criterion = "BIC", var.equal=TRUE)
B <- B[1:10]
data.comparison(A, B, criterion = "BIC", var.equal=TRUE)
A <- rnorm(100, 10, 2)
B <- rnorm(100, 10.1, 2)
C <- rnorm(100, 10.5, 2)
data.comparison(A, B, criterion = "BIC", var.equal=TRUE)
B <- B[1:10]
data.comparison(A, B, criterion = "BIC", var.equal=TRUE)
t.test(A, B, var.equal=TRUE)

###########################

replicates <- 500
x <- seq(from=8, to=13, by=0.1)
dataf <- matrix(rep(NA, replicates*length(x)), nrow=replicates)
dataf2 <- dataf

for (repl in 1:replicates) {
  
  pv <- NULL
  aw <- NULL
  
  for (meanB in x) {
    A <- rnorm(100, mean=10, sd=2)
    B <- rnorm(100, mean=meanB, sd=4)
    
    pv <- c(pv, t.test(A, B, var.equal = FALSE)$p.value)
    aw <- c(aw, data.comparison(A, B, criterion="BIC", var.equal = FALSE))
  }
  
  dataf[repl, ] <- pv
  dataf2[repl, ] <- aw
  
}

y <- colSums(dataf)/replicates
plot(x=x, y=y, type="l", 
     bty="n", las=1, xlab="Mean B value (SD = 4)", ylab="Probability", ylim=c(0,1), 
     main="Comparison of two data series, A and B (n=100)")
y2 <- colSums(dataf2)/replicates
lines(x=x, y=y2, type="l", col="red")

x[which(y2>0.05)[1]]
rev(x)[which(rev(y2)>0.05)[1]]

x[which(y>0.05)[1]]
rev(x)[which(rev(y)>0.05)[1]]

segments(x0=10-1.96*2/10, x1=10+1.96*2/10, y0=1, y1=1, lwd=2)
segments(x0=10, x1=10, y0=0.95, y1=1.05, lwd=2)
par(xpd=TRUE)
text(x=10, y=1.1, labels = "Mean A = 10, SD = 2")

legend("topright", legend=c("p-value\\nbased on t-test", 
                            "Akaike weight\\nfor same A and B model"), 
       y.intersp = 2, 
       col=c("black", "red"), bty="n", lty=1)

segments(x0=min(x), x1=max(x), y0=0.05, y1=0.05, lty=2)
par(xpd = TRUE)
text(x=13.05, y=0.05, labels = "0.05", pos=4)



####################################
replicates <- 100
x <- seq(from=8, to=13, by=0.1)
dataf <- matrix(rep(NA, replicates*length(x)), nrow=replicates)
dataf2 <- dataf

for (repl in 1:replicates) {
  
  pv <- NULL
  aw <- NULL
  
  for (meanB in x) {
    A <- rnorm(100, 10, 2)
    B <- rnorm(100, mean=meanB, sd=2)
    
    pv <- c(pv, t.test(A, B, var.equal = TRUE)$p.value)
    aw <- c(aw, data.comparison(A, B, criterion="BIC", var.equal = TRUE))
  }
  
  dataf[repl, ] <- pv
  dataf2[repl, ] <- aw
  
}

y <- colSums(dataf)/replicates
plot(x=x, y=y, type="l", 
     bty="n", las=1, xlab="Mean B value (SD = 2)", ylab="Probability", ylim=c(0,1), 
     main="Comparison of data series, A and B (n=100)")
y2 <- colSums(dataf2)/replicates
lines(x=x, y=y2, type="l", col="red")

x[which(y2>0.05)[1]]
rev(x)[which(rev(y2)>0.05)[1]]

x[which(y>0.05)[1]]
rev(x)[which(rev(y)>0.05)[1]]


segments(x0=10-1.96*2/10, x1=10+1.96*2/10, y0=1, y1=1, lwd=2)
segments(x0=10, x1=10, y0=0.95, y1=1.05, lwd=2)
par(xpd=TRUE)
text(x=10, y=1.1, labels = "Mean A = 10, SD = 2")

legend("topright", legend=c("p-value\\nbased on t-test", 
                            "Akaike weight\\nfor same A and B model"), 
       y.intersp = 2, 
       col=c("black", "red"), bty="n", lty=1)

segments(x0=min(x), x1=max(x), y0=0.05, y1=0.05, lty=2)
par(xpd=TRUE)
text(x=13.05, y=0.05, labels = "0.05", pos=4)
}
}
\author{
Marc Girondot
}

