% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/temperature.periodic.R
\name{temperature.periodic}
\alias{temperature.periodic}
\title{Estimate temperatures in periodic timeseries based on anchored minimum and maximum}
\usage{
temperature.periodic(minmax, time = NULL, replicates = 100,
  progressbar = FALSE)
}
\arguments{
\item{minmax}{A data.frame returned by minmax.periodic}

\item{time}{The time at which produced the estimate}

\item{replicates}{Number of replicates to estimate sd}

\item{progressbar}{Does a progression bar must be shown}
}
\value{
A data.frame with a column time and a column temperature
}
\description{
Estimate temperatures in periodic timeseries based on anchored minimum and maximum.\cr
The data.frame minmax can be generated manually. It should have three columns (time, temperature, SD),
with all the successive minimum and maximum temperatures.
}
\details{
temperature.periodic estimate temperatures in periodic timeseries based on anchored minimum and maximum
}
\examples{
\dontrun{
# Generate a timeserie of time
time.obs <- NULL
for (i in 0:9) time.obs <- c(time.obs, c(0, 6, 12, 18)+i*24)
# For these time, generate a timeseries of temperatures
temp.obs <- rep(NA, length(time.obs))
temp.obs[3+(0:9)*4] <- rnorm(10, 25, 3)
temp.obs[1+(0:9)*4] <- rnorm(10, 10, 3)
for (i in 1:(length(time.obs)-1))
  if (is.na(temp.obs[i]))
  temp.obs[i] <- mean(c(temp.obs[i-1], temp.obs[i+1]))
  if (is.na(temp.obs[length(time.obs)]))
  temp.obs[length(time.obs)] <- temp.obs[length(time.obs)-1]/2
observed <- data.frame(time=time.obs, temperature=temp.obs)
# Search for the minimum and maximum values
r <- minmax.periodic(time.minmax.daily=c(Min=2, Max=15),
observed=observed, period=24)

# Estimate all the temperatures for these values
t <- temperature.periodic(minmax=r)

plot_errbar(x=t[,"time"], y=t[,"temperature"],
errbar.y=ifelse(is.na(t[,"sd"]), 0, 2*t[,"sd"]),
type="l", las=1, bty="n", errbar.y.polygon = TRUE,
xlab="hours", ylab="Temperatures", ylim=c(0, 35),
errbar.y.polygon.list = list(col="grey"))

plot_add(x=t[,"time"], y=t[,"temperature"], type="l")
}
}
\author{
Marc Girondot
}
\seealso{
Other Daily patterns of temperature: \code{\link{minmax.periodic}}
}

