#' HTSSIP: analyzing high throughput sequence data from nucleotide stable isotope probing experiments
#'
#' HTSSIP provides a toolset for reproducibly analyzing HTS-SIP data.
#' HTS-SIP data is the combination of nucleotide stable isotope probing (DNA- & RNA-SIP)
#' and high throughput sequence data (e.g., MiSeq of 16S rRNA amplicons).
#'
#' To learn more about HTSSIP, start with the vignettes:
#' \code{browseVignettes(package = "HTSSIP")}
#'
#' @docType package
#' @name HTSSIP
#' @importFrom magrittr %>%
#' @import dplyr
#' @import tidyr
#' @import ggplot2
NULL
