% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLStoUNI.R
\name{GLStoUNI}
\alias{GLStoUNI}
\title{Translate GL String to UNIFORMAT}
\usage{
GLStoUNI(GLstring, prefix = "HLA-", pre = FALSE)
}
\arguments{
\item{GLstring}{A character string of HLA allele names and operators in the GL String format signifying their relation with one another.}

\item{prefix}{A character string of the pertinent gene-system prefix (default is "HLA-").}

\item{pre}{A logical that indicates whether returned allele names should contain 'prefix' (TRUE), or if 'prefix' should be excluded from returned names (FALSE).}
}
\value{
A version of 'GLstring' converted to UNIFORMAT format, or FALSE if 'GLstring' is invalid.
}
\description{
A wrapper function for GLtoUN, which translates strings from GL String format to UNIFORMAT format.
}
\note{
This function does not function with the "?" operator, as the "?" operator has no cognate in UNIFORMAT.
}
\examples{

GLStoUNI("HLA-A*02:01/HLA-A*02:02+HLA-A*03:01/HLA-A*03:02")
GLStoUNI("A+B/C~D^G|E^W+X/Y^Z+J")

}
\references{
Nunes Tissue Antigens 2007;69(s1):203-205 https://doi.org/10.1111/j.1399-0039.2006.00808.x

Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
