% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hima_efficient.R
\name{hima_efficient}
\alias{hima_efficient}
\title{Efficient high-dimensional mediation analysis}
\usage{
hima_efficient(
  X,
  M,
  Y,
  COV = NULL,
  topN = NULL,
  scale = TRUE,
  FDRcut = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{X}{a vector of exposure. Do not use \code{data.frame} or \code{matrix}.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns
represent mediator variables. \code{M} has to be continuous and normally distributed.}

\item{Y}{a vector of continuous outcome. Do not use \code{data.frame} or \code{matrix}.}

\item{COV}{a matrix of adjusting covariates. Rows represent samples, columns represent variables. Can be \code{NULL}.}

\item{topN}{an integer specifying the number of top markers from sure independent screening.
Default = \code{NULL}. If \code{NULL}, \code{topN} will be \code{2*ceiling(n/log(n))}, where \code{n} is the sample size.
If the sample size is greater than topN (pre-specified or calculated), all mediators will be included in the test (i.e. low-dimensional scenario).}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{FDRcut}{Benjamini-Hochberg FDR cutoff applied to select significant mediators. Default = \code{0.05}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}
}
\value{
A data.frame containing mediation testing results of significant mediators (FDR <\code{FDRcut}).
\describe{
    \item{Index: }{mediation name of selected significant mediator.}
    \item{alpha_hat: }{coefficient estimates of exposure (X) --> mediators (M) (adjusted for covariates).}
    \item{alpha_se: }{standard error for alpha.}
    \item{beta_hat: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for covariates and exposure).}
    \item{beta_se: }{standard error for beta.}
    \item{IDE: }{mediation (indirect) effect, i.e., alpha*beta.}
    \item{rimp: }{relative importance of the mediator.}
    \item{pmax: }{joint raw p-value of selected significant mediator (based on divide-aggregate composite-null test [DACT] method).}
}
}
\description{
\code{hima_efficient} is used to estimate and test high-dimensional mediation effects using an efficient algorithm. It provides
higher statistical power than the standard \code{hima}. Note: efficient HIMA is only applicable to mediators and outcomes that
are both continuous and normally distributed.
}
\examples{
\dontrun{
# Note: In the following example, M1, M2, and M3 are true mediators.

# Y is continuous and normally distributed
# Example (continuous outcome):
head(ContinuousOutcome$PhenoData)

hima_efficient.fit <- hima_efficient(
  X = ContinuousOutcome$PhenoData$Treatment,
  Y = ContinuousOutcome$PhenoData$Outcome,
  M = ContinuousOutcome$Mediator,
  COV = ContinuousOutcome$PhenoData[, c("Sex", "Age")],
  scale = FALSE, # Disabled only for simulation data
  FDRcut = 0.05,
  verbose = TRUE
)
hima_efficient.fit
}

}
\references{
Bai X, Zheng Y, Hou L, Zheng C, Liu L, Zhang H. An Efficient Testing Procedure for High-dimensional Mediators with FDR Control.
Statistics in Biosciences. 2024. DOI: 10.1007/s12561-024-09447-4.
}
