% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{preprocessDB}
\alias{preprocessDB}
\title{preprocessDB}
\usage{
preprocessDB(sampleList, GOGOA3, ontology, mn, mx, thresh, verbose)
}
\arguments{
\item{sampleList}{character list of gene names}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{ontology}{character string c("molecular_function", "cellular_component", "biological_process")}

\item{mn}{integer param passed to trimGOGOA3, min size threshold for a category}

\item{mx}{integer param passed to trimGOGOA3, max size threshold for a category}

\item{thresh}{numerical paramter passed to checkGeneListVsDB()}

\item{verbose}{integer vector representing classes}
}
\value{
returns a list whose components are a trimmed version of GOGOA3 and (for human)
a sampleList with validated HGNC symbols
}
\description{
driver to perform several preprocessing steps:
quick peek
trim small and large categories
is the database for human species
validate validated HGNC symbols in sampleList
determine up to date (ie, contains GOGOA3$species) or legacy version of human database
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")
pp<-preprocessDB(cluster52,GOGOA3,"biological_process",20,200,0.5,3)
}

}
