% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{GOheatmap}
\alias{GOheatmap}
\title{GOheatmap}
\usage{
GOheatmap(sampleList, x, thresh, fdrThresh = 0.105)
}
\arguments{
\item{sampleList}{character list of gene names}

\item{x}{DB component of return value of GOtable3()}

\item{thresh}{output of GOthresh()}

\item{fdrThresh}{numeric value of FDR acceptance threshold}
}
\value{
returns a matrix to be used as input to a heat map
}
\description{
generate a matrix to be used as input to a heat map
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO
#load("~/GODB_RDATA/GOGOA3.RData")
ONT<-"biological_process"
DB<-GOGOA3$ontologies[[ONT]]

#load("data/cluster52.RData")
sampleList<-cluster52

#load("data/x_thresh.RData")
heatmap<-GOheatmap(sampleList,DB,x_thresh)
}

}
