% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{assign_coords_to_grid}
\alias{assign_coords_to_grid}
\title{Assign Geographic Coordinates to Grid Cells}
\usage{
assign_coords_to_grid(coords, cell_size)
}
\arguments{
\item{coords}{A data frame or matrix with two columns: longitude and latitude.}

\item{cell_size}{Numeric value representing the size of each grid cell, typically in degrees.}
}
\value{
A character vector of grid cell identifiers, where each identifier is formatted as "x_y", representing the grid cell coordinates.
}
\description{
This function assigns a set of geographic coordinates (longitude and latitude) to grid cells based on a specified cell size.
}
\examples{
coords <- data.frame(long = c(-122.4194, 0), lat = c(37.7749, 0))
cell_size <- 1
assign_coords_to_grid(coords, cell_size)
}
