% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_start_end.R
\name{plot_start_end}
\alias{plot_start_end}
\title{Plot both the starting frequencies and the final frequencies in one plot}
\usage{
plot_start_end(results, picked_ancestor = "ALL", picked_population = 1)
}
\arguments{
\item{results}{An object which is the result of \code{simulate_admixture},
being a list with four properties:
\code{population}, \code{frequencies}, \code{initial_frequencies} and
\code{final frequencies}}

\item{picked_ancestor}{Default is "ALL", where different colors indicate
different ancestors. Alternatively, for clarity, the user can specify a
specific ancestral allele, and only that allele is plotted}

\item{picked_population}{If multiple populations were simulated (in the case
of \code{simulate_admixture_migration}), which population should be plotted?
Default is population_1.}
}
\value{
a ggplot object
}
\description{
This function plots the distribution of both the starting and
the final frequencies in one plot
}
\examples{
markers <- seq(from = 0.2, to = 0.3, length.out = 100)

pop <- simulate_admixture(
            module = ancestry_module(number_of_founders = 3,
                                     morgan = 1,
                                     markers = markers),
           pop_size = 1000,
           total_runtime = 11)
require(ggplot2)
plot_start_end(pop,
               picked_ancestor = "ALL")
plot_start_end(pop,
               picked_ancestor = 1)
}
