% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_set_credentials}
\alias{galaxy_set_credentials}
\title{Set Galaxy connection parameters for the current R session}
\usage{
galaxy_set_credentials(
  api_key = NULL,
  username = NULL,
  password = NULL,
  galaxy_url = "https://usegalaxy.eu",
  overwrite = TRUE
)
}
\arguments{
\item{api_key}{Character. Galaxy API key.}

\item{username}{Character. Galaxy username (only required for FTP uploads).}

\item{password}{Character. Galaxy password (only required for FTP uploads).}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(e.g. \code{"https://usegalaxy.eu"}). If set all galaxy_url arguments of functions will be ignored.}

\item{overwrite}{Logical. Whether to overwrite existing environment
variables. Default: \code{TRUE}.}
}
\value{
Invisibly returns a named list of values that were set.
}
\description{
Set Galaxy connection parameters for the current R session
}
\details{
This helper is intended for interactive sessions. It sets the following
environment variables using \code{Sys.setenv()}:

\itemize{
\item \code{GALAXY_API_KEY}
\item \code{GALAXY_URL}
\item \code{GALAXY_USERNAME}
\item \code{GALAXY_PASSWORD}
}

Only arguments that are provided (non-NULL) are set.
}
\examples{
# This requires valid credentials to your galaxy instance
\dontrun{
galaxy_set_credentials(
  api_key = "your-secret-key",
  username = "your-username",
  password = "your-password",
  galaxy_url = "https://usegalaxy.eu"
)
}

}
