% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.lsn.boundaries.R
\name{grin.lsn.boundaries}
\alias{grin.lsn.boundaries}
\title{GRIN Evaluate Lesion Boundaries}
\usage{
grin.lsn.boundaries(lsn.data, chrom.size)
}
\arguments{
\item{lsn.data}{Lesion data file that should be limited to include either gain or deletions. If gains are splitted to gain and amplifications based on the log2Ratio value of the CNV segmentation file, the two categories can be included in the same data table, same for homozygous and heterozygous deletions.}

\item{chrom.size}{Chromosize size table that should include two columns "chrom" with the chromosome number and "size" with the chromosome size in base pairs.}
}
\value{
Function return a data.frame with five columns:
\item{gene}{Ordered boundaries by unique start and end positions of different lesions on each chromosome.}
\item{chrom}{Chromosome on which the bounday is located.}
\item{loc.start}{Boundary start position.}
\item{loc.end}{Boundary end position.}
\item{diff}{Boundary size in base pairs.}
}
\description{
The function evaluates Copy number variations that include gain and deletions as boundaries based on unique lesion start and end positions. This analysis is lesion type specific and covers the entire genome.
}
\details{
The function evaluates Copy number variations that include gain and deletions as boundaries and return a table of ordered boundaries based on the unique start and end positions of different lesions on each chromosome. If gains are splitted to gain and amplifications based on the log2Ratio value of the CNV segmentation file, the two categories can be included in the same analysis, same for homozygous and heterozygous deletions. Boundary will be the region between each unique start and end positions where large size lesions will be splitted into multiple boundaries based on other smaller size lesions that affect the same region in other patients if any. This analysis is meant to cover the entire genome, so regions without any annotated genes or regulatory features will be incuded will be assesed in the analysis. The first boundary for each chromosome will start from the first nucleotide base on the chromosome till the start position of the first lesion that affect the chromosome. Similarly, the last boundary will start from the end position of the last lesion that affect the chromosome till the last base on the chromosome.
}
\examples{
data(lesion.data)
data(hg19.chrom.size)

# This analysis is lesion type specific. So, user should first data extract data for a specific
# lesion group of interest for example gains from the lesion data file:
gain=lesion.data[lesion.data$lsn.type=="gain",]
# Return lesion boundaries for gains:
lsn.bound.gain=grin.lsn.boundaries(gain, hg19.chrom.size)
# Run GRIN analysis Using Lesion Boundaries markers Instead of the gene annotation file:
GRIN.results.gain.bound=grin.stats(gain, lsn.bound.gain, hg19.chrom.size)

# same analysis can be done for mutations, deletions and structural rearrangments.
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
