% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestFunctions.R
\name{ZDT1}
\alias{DTLZ1}
\alias{DTLZ2}
\alias{DTLZ3}
\alias{DTLZ7}
\alias{MOP2}
\alias{MOP3}
\alias{P1}
\alias{P2}
\alias{ZDT1}
\alias{ZDT2}
\alias{ZDT3}
\alias{ZDT4}
\alias{ZDT6}
\title{Test functions of x}
\usage{
ZDT1(x)

ZDT2(x)

ZDT3(x)

ZDT4(x)

ZDT6(x)

P1(x)

P2(x)

MOP2(x)

MOP3(x)

DTLZ1(x, nobj = 3)

DTLZ2(x, nobj = 3)

DTLZ3(x, nobj = 3)

DTLZ7(x, nobj = 3)
}
\arguments{
\item{x}{matrix specifying the location where the function is to be evaluated, one point per row,}

\item{nobj}{optional argument to select the number of objective for the DTLZ test functions.}
}
\value{
Matrix of values corresponding to the objective functions, the number of colums is the number of objectives.
}
\description{
Multi-objective test functions.
}
\details{
These functions are coming from different benchmarks:
the \code{ZDT} test problems from an article of E. Zitzler et al., \code{P1} from the thesis of J. Parr and \code{P2}
from an article of Poloni et al. . \code{MOP2} and \code{MOP3} are from Van Veldhuizen and \code{DTLZ} functions are from Deb et al. . \cr \cr

Domains (sometimes rescaled to \code{[0,1]}):
\itemize{
\item \code{ZDT1-6}: \code{[0,1]^d} 
\item \code{P1}, \code{P2}: \code{[0,1]^2} 
\item \code{MOP2}: \code{[0,1]^d}
\item \code{MOP3}: \code{[-3,3]}, tri-objective, 2 variables
\item \code{DTLZ1-3,7}: \code{[0,1]^d}, m-objective problems, with at least \code{d>m} variables. 
}
}
\examples{
# ----------------------------------
# 2-objectives test problems
# ---------------------------------- 

plotParetoGrid("ZDT1", n.grid = 21)

plotParetoGrid("ZDT2", n.grid = 21)

plotParetoGrid("ZDT3", n.grid = 21)

plotParetoGrid("ZDT4", n.grid = 21)

plotParetoGrid("ZDT6", n.grid = 21)

plotParetoGrid("P1", n.grid = 21)

plotParetoGrid("P2", n.grid = 21)

plotParetoGrid("MOP2", n.grid = 21)

}
\references{
J. M. Parr (2012), \emph{Improvement Criteria for Constraint Handling and Multiobjective Optimization}, University of Southampton, PhD thesis. 

C. Poloni, A. Giurgevich, L. Onesti, V. Pediroda (2000), Hybridization of a multi-objective genetic algorithm, a neural network and a classical optimizer for a complex design problem in fluid dynamics, \emph{Computer Methods in Applied Mechanics and Engineering}, 186(2), 403-420.

E. Zitzler, K. Deb, and L. Thiele (2000), Comparison of multiobjective evolutionary
algorithms: Empirical results, \emph{Evol. Comput.}, 8(2), 173-195.

K. Deb, L. Thiele, M. Laumanns and E. Zitzler (2002), Scalable Test Problems for Evolutionary Multiobjective Optimization, 
\emph{IEEE Transactions on Evolutionary Computation}, 6(2), 182-197.

D. A. Van Veldhuizen, G. B. Lamont (1999), Multiobjective evolutionary algorithm test suites, \emph{In Proceedings of the 1999 ACM symposium on Applied computing}, 351-357.
}

