library(GGIRread)
context("reading Genea binary data")
test_that("readGenea reads data from file correctly", {
  geneafile  = system.file("testfiles/genea_testfile.bin", package = "GGIRread")[1]
  GENEA = readGenea(filename = geneafile, start = 0, end = 4)
  expect_equal(nrow(GENEA$header), 18)
  expect_equal(GENEA$header[16], "Sample_Rate")
  expect_equal(nrow(GENEA$rawxyz), 1329)
  expect_equal(sum(GENEA$rawxyz), 1374990)
  expect_equal(nrow(GENEA$batt.voltage), 5)
  expect_equal(as.numeric(GENEA$batt.voltage[1, 3]), 1269950918)
  expect_equal(GENEA$timestamps1[100], 1269950918)
  expect_equal(as.character(format(GENEA$timestamps2[100], format = "%Y")), "2010")
  
  GENEA2 = readGenea(filename = geneafile, start = min(GENEA$timestamps2) , end = max(GENEA$timestamps2))
  expect_equal(nrow(GENEA2$header), 18)
  expect_equal(GENEA2$header[16], "Sample_Rate")
  expect_equal(nrow(GENEA2$rawxyz), 1329)
  expect_equal(sum(GENEA2$rawxyz), 1374990)
  expect_equal(nrow(GENEA2$batt.voltage), 5)
  expect_equal(as.numeric(GENEA2$batt.voltage[1, 3]), 1269950918)
  expect_equal(GENEA2$timestamps1[100], 1269950918)
  expect_equal(as.character(format(GENEA2$timestamps2[100], format = "%Y")), "2010")
  
})