% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_sample_mean_16102018.R
\name{Weighted.fuzzy.mean}
\alias{Weighted.fuzzy.mean}
\title{Calculates the weighted fuzzy sample mean}
\usage{
Weighted.fuzzy.mean(
  data.fuzzified,
  weight,
  breakpoints = 100,
  alphacuts = FALSE
)
}
\arguments{
\item{data.fuzzified}{a fuzzification matrix constructed by a call to the function FUZZ or the function GFUZZ, 
or a similar matrix. No NA are allowed.}

\item{weight}{a weighting vector of the same length of the fuzzification matrix. No NA allowed.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{alphacuts}{fixed by default to "FALSE". No alpha-cuts are printed in this case.}
}
\value{
If the parameter alphacuts="TRUE", the function returns a matrix composed by 2 vectors representing the numerical left and right alpha-cuts. For this output, is.alphacuts = TRUE. If the parameter alphacuts="FALSE", the function returns a trapezoidal fuzzy number given by the quadruple (p,q,r,s).
}
\description{
Calculates the weighted fuzzy sample mean
}
\examples{
mat <- matrix(c(1,2,2,3,3,4,4,5), ncol =4)
w <- c(1,3)
Weighted.fuzzy.mean(mat, w)
}
