% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_te.R
\name{tecov}
\alias{tecov}
\alias{tecov.default}
\alias{tecov.ols}
\alias{tecov.str}
\alias{tecov.wlsv}
\alias{tecov.wlsh}
\alias{tecov.acov}
\alias{tecov.strar1}
\alias{tecov.sar1}
\alias{tecov.har1}
\alias{tecov.shr}
\alias{tecov.sam}
\title{Temporal covariance matrix approximation}
\usage{
tecov(comb, agg_order = NULL, res = NULL, tew = "sum",
      mse = TRUE, shrink_fun = shrink_estim, ...)
}
\arguments{
\item{comb}{A string specifying the reconciliation method.
\itemize{
\item Ordinary least squares:
\itemize{
\item "\code{ols}" (\emph{default}) - identity error covariance.
}
\item Weighted least squares:
\itemize{
\item "\code{str}" - structural variances.
\item "\code{wlsh}" - hierarchy variances (uses \code{res}).
\item "\code{wlsv}" - series variances (uses \code{res}).
}
\item Generalized least squares (uses \code{res}):
\itemize{
\item "\code{acov}" - series auto-covariance.
\item "\code{strar1}" - structural Markov covariance.
\item "\code{sar1}" - series Markov covariance.
\item "\code{har1}" - hierarchy Markov covariance.
\item "\code{shr}"/"\code{sam}" - shrunk/sample covariance.
}
}}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{res}{A (\eqn{N(k^\ast+m) \times 1}) optional numeric vector containing the
in-sample residuals at all the temporal frequencies ordered from the lowest frequency
to the highest frequency. This vector is used to compute come covariance matrices.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{mse}{If \code{TRUE} (\emph{default}) the residuals used to compute the covariance
matrix are not mean-corrected.}

\item{shrink_fun}{Shrinkage function of the covariance matrix, \link{shrink_estim} (\emph{default})}

\item{...}{Not used.}
}
\value{
A (\eqn{(k^\ast+m) \times (k^\ast+m)}) symmetric matrix.
}
\description{
This function provides an approximation of the temporal base forecasts errors
covariance matrix using different reconciliation methods (see Di Fonzo and Girolimetto, 2023).
}
\examples{
# (7 x 70) in-sample residuals matrix (simulated), agg_order = 4
res <- rnorm(70)

cov1 <- tecov("ols", agg_order = 4)                 # OLS methods
cov2 <- tecov("str", agg_order = 4)                 # STRC methods
cov3 <- tecov("wlsv", agg_order = 4, res = res)     # WLSv methods
cov4 <- tecov("wlsh", agg_order = 4, res = res)     # WLSh methods
cov5 <- tecov("acov", agg_order = 4, res = res)     # ACOV methods
cov6 <- tecov("strar1", agg_order = 4, res = res)   # STRAR1 methods
cov7 <- tecov("har1", agg_order = 4, res = res)     # HAR1 methods
cov8 <- tecov("sar1", agg_order = 4, res = res)     # SAR1 methods
cov9 <- tecov("shr", agg_order = 4, res = res)      # SHR methods
cov10 <- tecov("sam", agg_order = 4, res = res)     # SAM methods

# Custom covariance matrix
tecov.ols2 <- function(comb, x) diag(x)
tecov(comb = "ols2", x = 7) # == tecov("ols", agg_order = 4)

}
\references{
Di Fonzo, T. and Girolimetto, D. (2023), Cross-temporal forecast reconciliation:
Optimal combination method and heuristic alternatives, \emph{International Journal
of Forecasting}, 39, 1, 39-57. \doi{10.1016/j.ijforecast.2021.08.004}
}
\seealso{
Temporal framework: 
\code{\link{teboot}()},
\code{\link{tebu}()},
\code{\link{telcc}()},
\code{\link{temo}()},
\code{\link{terec}()},
\code{\link{tetd}()},
\code{\link{tetools}()}
}
\concept{Framework: temporal}
