% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIT.R
\name{train}
\alias{train}
\title{Constructs models following a recipe.}
\usage{
train(expression, attribute, weather, recipe, weight = NULL,
  min.expressed.rate = 0.01)
}
\arguments{
\item{expression}{An object that represents gene expression data.
The object can be created from a dumped/saved dataframe
of size \code{nsamples * ngenes}
using \code{FIT::load.expression()}.
(At the moment it is an instance of a hidden class IO$Expression,
but this may be subject to change.)}

\item{attribute}{An object that represents the attributes of
microarray/RNA-seq data.
The object can be created from a dumped/saved dataframe
of size \code{nsamples * nattributes}
using \code{FIT::load.attribute()}.
(At the moment it is an instance of a hidden class IO$Attribute,
but this may be subject to change.)}

\item{weather}{An object that represents actual or hypothetical weather data
with which the training of models are done.
The object can be created from a dumped/saved dataframe
of size \code{ntimepoints * nfactors}
using \code{FIT::load.weather()}.
(At the moment it is an instance of a hidden class IO$Weather,
but this may be subject to change.)}

\item{recipe}{An object that represents the training protocol of models.
A recipe can be created using \code{FIT::make.recipe()}.}

\item{weight}{An optional numerical matrix of size \code{nsamples * ngenes}
    that during regression penalizes errors from each sample 
    using the formula
    \code{sum_{s in samples} (weight_s) (error_s)^2}.

    This argument is optional for a historical reason,
    and when it is omitted, all samples are equally penalized.}

\item{min.expressed.rate}{A number used to 
A gene with \code{var(expr) < thres.expr} is regarded as unexpressed,
and \pkg{FIT} sets its model as: \code{expr = log(offset) + 0*inputs}.}
}
\value{
A collection of trained models.
}
\description{
Constructs models following a recipe.
}
\examples{
\dontrun{
# create recipe
recipe <- FIT::make.recipe(..)

#load training data
training.attribute  <- FIT::load.attribute('attribute.2008.txt');
training.weather    <- FIT::load.weather('weather.2008.dat', 'weather')
training.expression <- FIT::load.expression('expression.2008.dat', 'ex', genes)
training.weight     <- FIT::load.weight('weight.2008.dat', 'weight', genes)

# train models
models <- FIT::train(training.expression,
                     training.attribute,
                     training.weather,
                     recipe,
                     training.weight)
}
}
