% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiental.R
\name{ptermal}
\alias{ptermal}
\title{Photothermal Index}
\usage{
ptermal(DAY, AAT, RAD, PER, verbose = FALSE)
}
\arguments{
\item{DAY}{The column with the cycle days}

\item{AAT}{The column with the average air temperature values}

\item{RAD}{The column with the incident radiation values}

\item{PER}{The column with the period (use VEG for vegetative and REP for
reproductive)}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Retorna o ind fototermal
}
\description{
Calculation of the photothermal index based on average temperature and
radiation
}
\examples{
library(EstimateBreed)
data("termaldata")

termal <- with(termaldata,ptermal(Day,Temperature,Radiation,Period))
termal
}
\references{
Zanon, A. J., & Tagliapietra, E. L. (2022). Ecofisiologia da soja:
Visando altas produtividades (2a ed.). Field Crops.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
