# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Infection Link Residual Test (Non-path-explicit)
#' @author Max S.Y. Lau <maxlauhk54@@gmail.com>
#'
#' @description Infection-link Residual Test (Non-path-explicit).
#'
#' @details The residual test specifically designed to test the goodness-of-fit of a spatial kernel.
#'Explicit sources of infections are not required and are imputed in the function.
#' @param kvalues  a nxn symmetric matrix where n is total number of subjects in the population. Entry at position (i,j) is the value of the spatial kernel  \eqn{K(d_{i,j})} where  \eqn{d_{i,j}} is the Euclidean distance between i and j. Diagonal entries are equal to 1.
#' @param E a vector contains the indices of infected cases excludingt the first case. Note that subjects are indexed from 0 (not 1).
#' @param I a vector contains the indices of infectious cases (being infectious or once infectious).
#' @param tr a vector contains the recovery times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).
#' @param ti a vector contains the times of becoming infectious of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). For a SIR model, {\code{ti}} should set to be {\code{te}}
#' @param te a vector contains the infection times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).
#' @param alpha the background infection rate
#' @param beta the secondary infection rate
#' @param n the total number of subjects
#' @param stb a vector contains the susceptibility of subjects (entries may set to be 1 if to be ignored).
#' @return a vector contains the set of  imputed residual for infected in the order of indexing.
#' @examples
#'data(epi)
#'
#'set.seed(1)
#'
#'n <- nrow(epi)
#'
#'kvalues_rk <- kvalues_wk <- matrix(NA,nrow=n, ncol=n) 
#'\dontrun{kvalues_wk is to be computed from an arbitrary wrong spatial kernel below}
#'diag(kvalues_rk) <- diag(kvalues_wk) <- 1
#'for (i in 1:n){
#'for (j in 1:n){
#'	if (i<j) {
#'		d_ij <- sqrt((epi$coor_x[i]-epi$coor_x[j])^2 + (epi$coor_y[i]-epi$coor_y[j])^2)
#'		kvalues_rk[i,j] <- exp(-0.02*(d_ij))
#'		kvalues_wk[i,j] <- 1.0/(d_ij^1.0)
#'	}
#'	if (i>j) {
#'		kvalues_rk[i,j] <- kvalues_rk[j,i]
#'		kvalues_wk[i,j] <- kvalues_wk[j,i]
#'	}
#'}
#'}
#'
#'E <- epi$k[which(epi$te!=9e+100 & epi$te!=min(epi$te))]
#'I <- epi$k[which(epi$ti!=9e+100)]
#'tr <- epi$tr
#'ti <- epi$ti
#'te <- epi$te
#'stb <- epi$stb
#'alpha <- 0.002
#'beta <- 8
#'infected_source <- epi$infected_source
#'
#'par(mfrow=c(1,2),mar=c(4,4,4,4))
#'hist(ILR(kvalues_rk,E, I,tr,ti,te,alpha,beta,n,stb), main="Correct Model", xlab="ILR")
#'hist(ILR(kvalues_wk,E,I,epi$tr,ti,te,alpha,beta,n,stb), main="Wrong Model", xlab="ILR")
#' @references Lau, Max SY, George Streftaris, Glenn Marion, Gavin J. Gibson. "New model diagnostics for spatio-temporal systems in epidemiology and ecology." Journal of The Royal Society Interface 11.93 (2014): 20131093.
#' @export
ILR <- function(kvalues, E, I, tr, ti, te, alpha, beta, n, stb) {
    .Call('EpiResTest_ILR', PACKAGE = 'EpiResTest', kvalues, E, I, tr, ti, te, alpha, beta, n, stb)
}

#' @title Infection Link Residual Test (Path Explicit)
#' @author Max S.Y. Lau <maxlauhk54@@gmail.com>
#'
#' @description Infection-link Residual Test (Path Explicit).
#'
#' @details The residual test specifically designed to test the goodness-of-fit of a spatial kernel.
#'Explicit sources of infections are required.
#' @param kvalues  a nxn symmetric matrix where n is total number of subjects in the population. Entry at position (i,j) is the value of the spatial kernel \eqn{K(d_{i,j})} where  \eqn{d_{i,j}} is the Euclidean distance between i and j. Diagonal entries are equal to 1.
#'@param E a vector contains the indices of infected cases excludingt the first case. Note that subjects are indexed from 0 (not 1).
#' @param I a vector contains the indices of infectious cases (being infectious or once infectious).
#' @param tr a vector contains the recovery times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).
#' @param ti a vector contains the times of becoming infectious of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). For a SIR model, {\code{ti}} set to be {\code{te}}
#' @param te a vector contains the infection times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10).
#' @param alpha the background infection rate
#' @param beta the secondary infection rate
#' @param n the total number of subjects
#' @param stb a vector contains the susceptibility of subjects (entries may set to be 1 if to be ignored).
#' @param path a vector contains the source of infection of the cases (entries for background infections and non-infected should be specified to be 9999 and -99 respectively).
#' @return a vector contains the set of  imputed residual for infected in the order of indexing.
#' @examples
#'data(epi)
#'
#'set.seed(1)
#'
#'n <- nrow(epi)
#'
#'kvalues_rk <- kvalues_wk <- matrix(NA,nrow=n, ncol=n) 
#'\dontrun{kvalues_wk is to be computed from an arbitrary wrong spatial kernel below}
#'diag(kvalues_rk) <- diag(kvalues_wk) <- 1
#'for (i in 1:n){
#'for (j in 1:n){
#'	if (i<j) {
#'		d_ij <- sqrt((epi$coor_x[i]-epi$coor_x[j])^2 + (epi$coor_y[i]-epi$coor_y[j])^2)
#'		kvalues_rk[i,j] <- exp(-0.02*(d_ij))
#'		kvalues_wk[i,j] <- 1.0/(d_ij^1.0)
#'	}
#'	if (i>j) {
#'		kvalues_rk[i,j] <- kvalues_rk[j,i]
#'		kvalues_wk[i,j] <- kvalues_wk[j,i]
#'	}
#'}
#'}
#'
#'E <- epi$k[which(epi$te!=9e+100 & epi$te!=min(epi$te))]
#'I <- epi$k[which(epi$ti!=9e+100)]
#'tr <- epi$tr
#'ti <- epi$ti
#'te <- epi$te
#'stb <- epi$stb
#'alpha <- 0.002
#'beta <- 8
#'infected_source <- epi$infected_source
#'
#'par(mfrow=c(1,2),mar=c(4,4,4,4))
#'hist(ILR_path(kvalues_rk,E,I,tr,ti,te,alpha,beta,n,stb,infected_source),
#'main="Correct Model",xlab="ILR")
#'hist(ILR_path(kvalues_wk,E,I,epi$tr,ti,te,alpha,beta,n,stb,infected_source), 
#'main="Wrong Model",xlab="ILR")
#' @references Lau, Max SY, George Streftaris, Glenn Marion, Gavin J. Gibson. "New model diagnostics for spatio-temporal systems in epidemiology and ecology." Journal of The Royal Society Interface 11.93 (2014): 20131093.
#' @export
ILR_path <- function(kvalues, E, I, tr, ti, te, alpha, beta, n, stb, path) {
    .Call('EpiResTest_ILR_path', PACKAGE = 'EpiResTest', kvalues, E, I, tr, ti, te, alpha, beta, n, stb, path)
}

#' @title Latent Time Residual
#' @author Max S.Y. Lau <maxlauhk54@@gmail.com>
#'
#' @description  Latent Time Residual.
#'
#' @details The residual test specifically designed to test the goodness-of-fit of the latent period (i.e., waiting time in class E) and the infectious period (i.e., waiting time in class I).
#'@param E a vector contains the indices of infected cases excludingt the first case. Note that subjects are indexed from 0 (not 1).
#' @param I a vector contains the indices of infectious cases (being infectious or once infectious).
#' @param EnI a vector contains the indices of  infected cases which have not yet been infectious (being infectious or once infectious).
#' @param ti a vector contains the times of becoming infectious of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). For testing waiting time in class I, {\code{ti}} should be set to be the time of recovery  {\code{tr}} 
#' @param te a vector contains the infection times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). . For testing waiting time in class I, {\code{te}} should be set to be the time of recovery  {\code{ti}} 
#' @param para either a one-element numeric vector or two-parameter vector contains the parameter arguments of the waiting time distribution to be specified by the user (see argument {\code{wt}}.
#' @param tmax the maximum duration of the observational period
#' @param wt the cumulative distribution function of the waiting time distribution specified by the user; note that the number of parameter arguments has to match with the length of {\code{para}}.
#' @return a vector contains the set of  imputed residual for infected in the order of indexing.
#' @examples
#'data(epi)
#'
#'set.seed(1)
#'
#'E <- epi$k[which(epi$te!=9e+100 & epi$te!=min(epi$te))]
#'I <- epi$k[which(epi$ti!=9e+100)]
#'EnI <- E[!(E%in%I)]
#'ti <- epi$ti
#'te <- epi$te
#'tmax <- 60
#'shape <- 10 #shape parameter for a Gamma waiting time in class E
#'rate <- 2 # rate parameter for a Gamma waiting time in class E
#'
#'para_gamma <- c(shape, rate)
#'para_exp <- shape/rate # an Exponential distribution to match the mean of the Gamma
#'
#'par(mfrow=c(1,2),mar=c(4,4,4,4))
#'hist(LTR(E, I, EnI, ti, te, para_gamma, tmax, pgamma), main="Correct Model", xlab="LTR")
#'hist(LTR(E, I, EnI, ti, te, para_exp, tmax, pexp), main="Wrong Model", xlab="LTR")
#' @references Lau, Max SY, George Streftaris, Glenn Marion, Gavin J. Gibson. "New model diagnostics for spatio-temporal systems in epidemiology and ecology." Journal of The Royal Society Interface 11.93 (2014): 20131093.
#' @export
LTR <- function(E, I, EnI, ti, te, para, tmax, wt) {
    .Call('EpiResTest_LTR', PACKAGE = 'EpiResTest', E, I, EnI, ti, te, para, tmax, wt)
}

