library(EpiILMCT)

# Just for illustation:
set.seed(4352)

# SIR distance-based ILM for a population of 10 individuals:
loc <- cbind(runif(10, 0, 10), runif(10,0,10))
net <- contactnet(type = "random", num.id = 10, location = loc, beta = 0.3)
infection <- c(2.5, 1, 0, 0, 0.5, 0, 2, 1.5, 0, 3)
removal <- c(3.5, 2, 0, 1, 1.5, 0, 3, 2.5, 0, 4)
id <- c(2, 1, 4, 7, 10, 3, 5, 9, 8, 6)

epi <- as.epidat(type = "SIR", kerneltype = "distance", inf.time = infection,
rem.time = removal, id.individual = id, location = loc)
epi

# using the data set generated by using the SINR network-based ILM:
data(NetworkDataSINR)
names(NetworkDataSINR)

netSINR<-as.epidat(type = "SINR", kerneltype = "network",
incub.time = NetworkDataSINR$epi[,4], inf.time = NetworkDataSINR$epi[,6],
rem.time = NetworkDataSINR$epi[,2], id.individual = NetworkDataSINR$epi[,1],
location  = NetworkDataSINR$loc, network = NetworkDataSINR$net,
network.type = "powerlaw")
names(netSINR)
netSINR$epidat

netSIR<-as.epidat(type = "SIR", kerneltype = "network",
inf.time = NetworkDataSINR$epi[,6], rem.time = NetworkDataSINR$epi[,2],
id.individual = NetworkDataSINR$epi[,1], location  = NetworkDataSINR$loc,
network = NetworkDataSINR$net, network.type = "powerlaw")
names(netSIR)
netSIR$epidat
