% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.R
\name{evaluateCiCalibration}
\alias{evaluateCiCalibration}
\title{Evaluate confidence interval calibration}
\usage{
evaluateCiCalibration(logRr, seLogRr, trueLogRr,
  strata = as.factor(trueLogRr),
  crossValidationGroup = 1:length(logRr), legacy = FALSE)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale.}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the
standard error = (log(<lower bound 95 percent confidence interval>) -
log(<effect estimate>))/qnorm(0.025).}

\item{trueLogRr}{The true log relative risk.}

\item{strata}{Variable used to stratify the plot. Set \code{strata = NULL} for no
stratification.}

\item{crossValidationGroup}{What should be the unit for the cross-validation? By default the unit
is a single control, but a different grouping can be provided, for
example linking a negative control to synthetic positive controls
derived from that negative control.}

\item{legacy}{If true, a legacy error model will be fitted, meaning standard 
deviation is linear on the log scale. If false, standard deviation
is assumed to be simply linear.}
}
\value{
A data frame specifying the coverage per strata (usually true effect size) for a wide range of widths
of the confidence interval. The result also includes the fraction of estimates that was below and above
the confidence interval.
}
\description{
\code{evaluateCiCalibration} performs a leave-one-out cross-validation to evaluate the calibration 
confidence intervals.
}
\details{
The empirical calibration is performed using a leave-one-out design: The confidence interval of an
effect is computed by fitting a null using all other controls.
}
\examples{
\dontrun{
data <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
eval <- evaluateCiCalibration(data$logRr, data$seLogRr, data$trueLogRr)
}
}
