% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysER.R
\name{analysER}
\alias{analysER}
\title{Analysing the results of simulations ran with \code{simER}}
\usage{
analysER(sim)
}
\arguments{
\item{sim}{A \code{simER} or a \code{compER} object.}
}
\value{
An object of class \code{data.frame}, which contains the average
sample number (ASN) at which the boundary is attained (either the lower or
the upper one), the percentage of hits of the lower boundary as well as hits
of the upper boundary, and the percentage of trajectories that did not hit
none of the boundaries (and thus end at nmax).
}
\description{
Analysing the results of simulations ran with \code{simER}.
It computes the average sample number (ASN) at which the boundary is attained
(either the lower or the upper one), the percentage of hits of the lower
boundary as well as hits of the upper boundary, and the percentage of
trajectories that did not hit none of the boundaries.
}
\examples{
\dontrun{
library(ESTER)
sim <- simER(cohensd = 0.8, nmin = 20, nmax = 100, boundary = 10, nsims = 100, ic = bic)
analysER(sim)
}

}
\seealso{
\code{\link{simER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
