% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangebreak.ribbon.R
\name{rangebreak.ribbon}
\alias{rangebreak.ribbon}
\title{rangebreak.ribbon Conduct a ribbon rangebreak test as described in Glor and Warren 2011.}
\usage{
rangebreak.ribbon(
  species.1,
  species.2,
  ribbon,
  env,
  type,
  f = NULL,
  width = 1,
  nreps = 99,
  nback = 1000,
  bg.source = "default",
  low.memory = FALSE,
  rep.dir = NA,
  verbose = FALSE,
  clamp = TRUE,
  ...
)
}
\arguments{
\item{species.1}{An emtools.species object}

\item{species.2}{An enmtools.species object}

\item{ribbon}{An enmtools.species object representing the region of marginal habtiat in the overlap between the species' ranges}

\item{env}{A SpatRaster object containing environmental data}

\item{type}{The type of model to construct, currently accepts "glm", "mx", "bc", or "dm"}

\item{f}{A function to use for model fitting.  Only required for GLM models at the moment.}

\item{width}{Width of the ribbon, in the same units as the occurrence points (e.g, decimal degrees)}

\item{nreps}{Number of replicates to perform}

\item{nback}{Number of background points for models}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{low.memory}{When set to TRUE, replicate models are written to disc instead of being stored in the output object.  Replicate models stored in the output object contain paths to the replicate models on disk instead of the rasters themselves.}

\item{rep.dir}{Directory for storing replicate models when low.memory is set to TRUE.  If not specified, the working directory will be used.}

\item{verbose}{Controls printing of various messages progress reports.  Defaults to FALSE.}

\item{clamp}{Controls whether empirical and replicate models should be clamped to the environment space used for training.}

\item{...}{Additional arguments to be passed to model fitting functions.}
}
\value{
results A list containing models for the replicates, models for the empirical data, and summary statistics and plots.
}
\description{
rangebreak.ribbon Conduct a ribbon rangebreak test as described in Glor and Warren 2011.
}
\examples{
\donttest{
cyreni <- iberolacerta.clade$species$cyreni
aranica <- iberolacerta.clade$species$aranica

# We're just going to fudge together occurrence data from a ribbon here
# from random points between the two species' ranges
p <- data.frame(x = runif(50, -4, -2), y = runif(50, 40, 43))
p <- terra::vect(p, geom = c("x", "y"), crs = terra::crs(cyreni$presence.points))
bg <- background.buffer(p, 100000, mask = euro.worldclim[[1]], n = 100, return.type = "points")
ribbon <- enmtools.species(species.name = "ribbon", presence.points = p, background.points = bg)

rangebreak.ribbon(cyreni, aranica, ribbon = ribbon, env = euro.worldclim,
type = "glm", f= pres ~ bio1 + bio12, nreps = 10)
}
}
\keyword{barrier}
\keyword{biogeography}
\keyword{enmtools}
\keyword{hypothesis-testing}
\keyword{rangebreak}
