% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumQdate.R
\name{cumQdate}
\alias{cumQdate}
\title{Cumulative flow calculation}
\usage{
cumQdate(eList, paStart = 10, paLong = 12, fract = 0.5)
}
\arguments{
\item{eList}{named list with at least the Sample and INFO dataframes}

\item{paStart}{numeric integer specifying the starting month for the period of analysis, 1 <= paStart <= 12, default is 10}

\item{paLong}{numeric integer specifying the length of the period of analysis, in months, 1 <= paLong <= 12, default is 12}

\item{fract}{numeric fraction of the flow}
}
\value{
annualSeries an integer matrix of two columns.
 The first column is the calendar year for the end of the period 
 The second column is day of the year when the flow has exceeded the specified fraction 
 of the entire period being considered
}
\description{
This function computes the first day of the calendar year
at which a specific fraction of the cumulative flow for that year
has been exceeded.  Typically one looks for the point where
half the cumulative flow has happened (fract = 0.5).
The portion of the year being considered is set by paStart and paLong.
The matrix returned has 2 columns: 
the first is the year (integer when the period of analysis ends),
the second is the day of the year when the fraction has been exceeded.
None of the rows will have any NA values.
}
\details{
It is common to use this type of analysis on the snowmelt period of the year.
If (for example) we assume that snowmelt starts with the month of March and ends in July
then we would set paStart = 3 and paLong = 5
}
\examples{
eList <- Choptank_eList
annualFlow <- cumQdate(eList)
head(annualFlow)
plot(annualFlow)
mod1 <- stats::lm(annualFlow[,2] ~ annualFlow[,1])
summary(mod1)
}
