% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metadata_dublin_core.R
\name{read_metadata_dublin_core}
\alias{read_metadata_dublin_core}
\title{Read metadata Dublin Core}
\usage{
read_metadata_dublin_core(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document) Dublin Core metadata.

See the 
\href{https://CRAN.R-project.org/package=xml2}{xml2} library 
for more on working with XML.
}
\description{
Read metadata Dublin Core
}
\examples{
\dontrun{

# Read dc metadata
dc <- read_metadata_dublin_core("knb-lter-nes.10.1")
dc
#> {xml_document}
#> <dc schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ http: ...
#> [1] <dc:type/>
#> [2] <dc:identifier/>
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
