% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_from_doi.R
\name{read_data_package_from_doi}
\alias{read_data_package_from_doi}
\title{Read data package from Digital Object Identifier}
\usage{
read_data_package_from_doi(doi, ore = FALSE)
}
\arguments{
\item{doi}{(character) Digital Object Identifier of data package in the
format "shoulder/pasta/md5"}

\item{ore}{(logical) Return an OAI-ORE compliant resource map in RDF-XML
format}
}
\value{
(character or xml_document) A resource map with reference URLs to
each of the metadata, data, and quality report resources that comprise the
data package.
}
\description{
Read data package from Digital Object Identifier
}
\examples{
\dontrun{

# Get resource map
resourceMap <- read_data_package_from_doi(
 doi = "doi:10.6073/pasta/b202c11db7c64943f6b4ed9f8c17fb25"
)
resourceMap
#> [1] "https://pasta.lternet.edu/package/data/eml/knb-lter-fce/1233/2/5 ...
#> [2] "https://pasta.lternet.edu/package/metadata/eml/knb-lter-fce/1233/2"
#> [3] "https://pasta.lternet.edu/package/report/eml/knb-lter-fce/1233/2"
#> [4] "https://pasta.lternet.edu/package/eml/knb-lter-fce/1233/2"

# Get resource map in ORE format
resourceMap <- read_data_package_from_doi(
 doi = "doi:10.6073/pasta/b202c11db7c64943f6b4ed9f8c17fb25",
 ore = TRUE
)
resourceMap
#> {xml_document}
#> <RDF xmlns:cito="http://purl.org/spar/cito/" xmlns:dc="http://purl.or ...
#> [1] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [2] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [3] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [4] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [5] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [6] <rdf:Description rdf:about="http://environmentaldatainitiative.or ...
#> [7] <rdf:Description rdf:about="http://www.openarchives.org/ore/terms ...
#> [8] <rdf:Description rdf:about="http://www.openarchives.org/ore/terms ...
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
