% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialmaster.R
\name{read_tm_all_xpt}
\alias{read_tm_all_xpt}
\title{Read all \code{.xpt} files in a directory}
\usage{
read_tm_all_xpt(directory, datetime_extraction)
}
\arguments{
\item{directory}{\verb{<character>} unzipped archive using SAS_XPORT format. Will read the extraction date from the directory name}

\item{datetime_extraction}{the datetime of the data extraction}
}
\value{
a list containing one dataframe for each \code{.xpt} file in the folder, the extraction date (\code{datetime_extraction}), and a summary of all imported tables (\code{.lookup}). If not set yet, option \code{edc_lookup} is automatically set to \code{.lookup}.
}
\description{
Read all \code{.xpt} files in a directory (unzipped TrialMaster archive). \cr
If \verb{7zip} is installed, you should probably rather use \code{\link[=read_trialmaster]{read_trialmaster()}} instead. \cr
If a \code{procformat.sas} file exists in the directory, formats will be applied.
}
