% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{calculate_metrics_at_threshold_dia}
\alias{calculate_metrics_at_threshold_dia}
\title{Calculate Classification Metrics at a Specific Threshold}
\usage{
calculate_metrics_at_threshold_dia(
  prob_positive,
  y_true,
  threshold,
  pos_class,
  neg_class
)
}
\arguments{
\item{prob_positive}{A numeric vector of predicted probabilities for the
positive class.}

\item{y_true}{A factor vector of true class labels.}

\item{threshold}{A numeric value between 0 and 1, the probability threshold
above which a prediction is considered positive.}

\item{pos_class}{A character string, the label for the positive class.}

\item{neg_class}{A character string, the label for the negative class.}
}
\value{
A list containing:
\itemize{
\item \code{Threshold}: The threshold used.
\item \code{Accuracy}: Overall prediction accuracy.
\item \code{Precision}: Precision for the positive class.
\item \code{Recall}: Recall (Sensitivity) for the positive class.
\item \code{F1}: F1-score for the positive class.
\item \code{Specificity}: Specificity for the negative class.
\item \code{TP}, \code{TN}, \code{FP}, \code{FN}, \code{N}: Counts of True Positives, True Negatives,
False Positives, False Negatives, and total samples.
}
}
\description{
Calculates various classification performance metrics (Accuracy,
Precision, Recall, F1-score, Specificity, True Positives, etc.) for binary
classification at a given probability threshold.
}
\examples{
y_true_ex <- factor(c("Negative", "Positive", "Positive", "Negative", "Positive"),
                    levels = c("Negative", "Positive"))
prob_ex <- c(0.1, 0.8, 0.6, 0.3, 0.9)
metrics <- calculate_metrics_at_threshold_dia(
  prob_positive = prob_ex,
  y_true = y_true_ex,
  threshold = 0.5,
  pos_class = "Positive",
  neg_class = "Negative"
)
print(metrics)
}
