% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotProportionOfPatientsCovered}
\alias{plotProportionOfPatientsCovered}
\title{Plot proportion of patients covered}
\usage{
plotProportionOfPatientsCovered(
  result,
  facet = "cohort_name",
  colour = strataColumns(result),
  ribbon = TRUE,
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{ribbon}{Whether to plot a ribbon with the confidence intervals.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{visOmopResults::setGlobalPlotOptions()}) or a \verb{_brand.yml} file is present
(in that order). Refer to the \strong{visOmopResults} package vignette on styles
to learn more.}
}
\value{
Plot of proportion Of patients covered over time
}
\description{
Plot proportion of patients covered
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "my_cohort",
                                        conceptSet = list(drug_of_interest = c(1503297, 1503327)))

result <- cdm$my_cohort |>
  summariseProportionOfPatientsCovered(followUpDays = 365)

plotProportionOfPatientsCovered(result)
}

}
