% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_structure.R
\name{genderize}
\alias{genderize}
\title{'Genderizes' a name}
\usage{
genderize(
  name,
  country_id = NULL,
  simplify = TRUE,
  apikey = get_api_key(),
  meta = FALSE
)
}
\arguments{
\item{name}{Name/s to estimate the gender. Can be a single \code{character}
string or a \code{character} vector. Obligatory parameter.}

\item{country_id}{Responses will in a lot of cases be more accurate if the
data is narrowed to a specific country. This optional parameter allows to
specify a specific country. The parameter must be a country code following
the common \href{http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO
3166-1 alpha-2} country code convention. To see a list of the supported
countries use the \code{\link{supported_countries}} function or visit the
following \href{https://genderize.io/our-data}{link}.}

\item{simplify}{Defines if the result should be returned as a single vector
or a \code{data.frame} with additional information. By default set to
\code{TRUE}, which returns a vector. If set to \code{FALSE}, it will
include additional information about: \itemize{ \item The probability
indicating the certainty of the assigned gender. Basically the ratio of
male to females. \item The count representing the number of data rows
examined in order to calculate the response. }}

\item{apikey}{Optional parameter to pass the API key. The API is free for up
to 1000 names/day. No sign up or API key needed. Yet, if more requests
would be needed, visit the \href{https://store.genderize.io/}{genderize.io
store} and the obtained API key can be passed through this parameter. The
API can also be saved one time through the \code{\link{save_api_key}} function,
so it is not necessary to call again.}

\item{meta}{\code{Logical} parameter to define if API related information
should be returned. By default set to \code{FALSE}. Returns information
about: \itemize{ \item The amount of names available in the current time
window \item The number of names left in the current time window \item
Seconds remaining until a new time window opens }}
}
\value{
The estimated age in a single \code{character} vector form or a
  \code{data.frame} with additional information.
}
\description{
Function to estimate the gender from a first name. Connects
  directly to the \href{https://genderize.io/}{genderize.io API} sending a
  request with a name and parses the response to return the predicted gender.
}
\details{
The function automatically handles pagination (max. 10 names per API
  request), missing values & duplicated values. If a name is duplicated for
  the same \code{country_id} (if the parameter has been passed), it will
  handle the request as a a single name to save requests, returning the same
  value for the duplicated names. To see more details about the API
  documentation, visit the \href{https://genderize.io/}{genderize.io
  website}.
}
\section{Warning}{
 Please be aware about local privacy protection regulations
  such as
  \href{https://tinyurl.com/odvcvq8}{GDPR}
   when dealing with personal data.
}

\examples{
\donttest{
genderize(name=c("Ben", "Maria"))
}
}
\seealso{
\code{\link{nationalize}}, \code{\link{agify}}
}
\author{
Matthias Brenninkmeijer -
  \href{https://github.com/matbmeijer}{https://github.com/matbmeijer}
}
