% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DECORATE.R
\name{predict.DECORATE}
\alias{predict.DECORATE}
\title{Predict method for DECORATE objects}
\usage{
\method{predict}{DECORATE}(object, newdata, all = FALSE, ...)
}
\arguments{
\item{object}{an object of the class \code{DECORATE}, as created by the function \code{DECORATE}.}

\item{newdata}{a data frame containing the same predictors as in the training phase.}

\item{all}{Return the predictions per tree instead of the average (default = FALSE).}

\item{...}{Not used currently.}
}
\value{
vector containing the response probabilities.
}
\description{
Prediction of new data using DECORATE
}
\examples{

data(iris)
y <- as.factor(ifelse(iris$Species[1:100]=="setosa",0,1))
x <- iris[1:100,-5]
dec <- DECORATE(x = x, y = y)
predict(object=dec,newdata=x)


}

