% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_columns.r
\name{split_columns}
\alias{split_columns}
\title{Split data into discrete and continuous parts}
\usage{
split_columns(data, binary_as_factor = FALSE)
}
\arguments{
\item{data}{input data}

\item{binary_as_factor}{treat binary as categorical? Default is \code{FALSE}.}
}
\value{
\code{discrete} all discrete features

\code{continous} all continuous features

\code{num_discrete} number of discrete features

\code{num_continuous} number of continuous features

\code{num_all_missing} number of features with no observations (all values are missing)
}
\description{
This function splits the input data into two \link{data.table} objects: discrete and continuous. A feature is continuous if \code{is.numeric} returns \code{TRUE}.
}
\details{
Features with all missing values will be dropped from the output data, but will be counted towards the column count.

The elements in the output list will have the same class as the input data.
}
\examples{
output <- split_columns(iris)
output$discrete
output$continuous
output$num_discrete
output$num_continuous
output$num_all_missing
}
\keyword{split_columns}
