% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_heterogeneity_ode.R
\name{simulate_heterogeneity_ode}
\alias{simulate_heterogeneity_ode}
\title{Simulation of a compartmental infectious disease transmission model with 2 types of hosts}
\usage{
simulate_heterogeneity_ode(
  S1 = 1000,
  I1 = 1,
  S2 = 1000,
  I2 = 0,
  b11 = 0.01,
  b12 = 0,
  b21 = 0,
  b22 = 0,
  g1 = 1,
  g2 = 1,
  w1 = 0,
  w2 = 0,
  tmax = 120
)
}
\arguments{
\item{S1}{: initial number of susceptible type 1 hosts : numeric}

\item{I1}{:  initial number of infected type 1 hosts : numeric}

\item{S2}{:  initial number of susceptible type 2 hosts : numeric}

\item{I2}{:  initial number of infected type 2 hosts : numeric}

\item{b11}{:  rate of transmission from infected type 1 host to susceptible type 1 host : numeric}

\item{b12}{:  rate of transmission from infected type 1 host to susceptible type 2 host : numeric}

\item{b21}{:  rate of transmission from infected type 2 host to susceptible type 1 host : numeric}

\item{b22}{:  rate of transmission from infected type 2 host to susceptible type 2 host : numeric}

\item{g1}{:  the rate at which infected type 1 hosts recover : numeric}

\item{g2}{:  the rate at which infected type 2 hosts recover : numeric}

\item{w1}{:  the rate at which type 1 host immunity wanes : numeric}

\item{w2}{:  the rate at which type 2 host immunity wanes : numeric}

\item{tmax}{:  maximum simulation time, units of months : numeric}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
This model allows for the simulation of an ID with 2 types of hosts
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_heterogeneity_ode()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_heterogeneity_ode(S1 = 100, S2 = 1e3, b11 = 0.7, tmax = 100)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[,"time"],result$ts[,"S1"],xlab='Time',ylab='Number Susceptible 1',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the Shiny app 'Host Heterogeneity', which is part of this package, contains more details on the model.
}
\author{
Andreas Handel
}
