% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_fit_noro.R
\name{simulate_fit_noro}
\alias{simulate_fit_noro}
\title{Fitting a simple SIR type model to norovirus outbreak data}
\usage{
simulate_fit_noro(
  S = 100,
  I = 1,
  R = 0,
  b = 0.001,
  blow = 1e-10,
  bhigh = 0.1,
  g = 0.5,
  glow = 0.001,
  ghigh = 100,
  n = 0,
  nlow = 0,
  nhigh = 1000,
  t1 = 8,
  t2 = 15,
  fitmodel = 1,
  iter = 100,
  solvertype = 1
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{b}{: infection rate : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{g}{: recovery rate : numeric}

\item{glow}{: lower bound for g : numeric}

\item{ghigh}{: upper bound for g : numeric}

\item{n}{: rate of infection from common source : numeric}

\item{nlow}{: lower bound for n : numeric}

\item{nhigh}{: upper bound for n : numeric}

\item{t1}{: start time of infection from common source : numeric}

\item{t2}{: end time of infection from common source: numeric}

\item{fitmodel}{: fitting model variant 1, 2 or 3 : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}

\item{solvertype}{: the type of solver/optimizer to use (1-3) : numeric}
}
\value{
The function returns a list containing the best fit timeseries,
the best fit parameters, the data and the AICc for the model.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple SIR model with an additional
environmental source of infection
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
}
\details{
Three versions of a simple SIR type compartmental ODE model
are fit to cases of norovirus during an outbreak.
#' @section Warning: This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}
\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_fit_noro()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_fit_noro(iter = 5, fitmodel = 2)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
