% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_vectortransmission_ode.R
\name{simulate_vectortransmission_ode}
\alias{simulate_vectortransmission_ode}
\title{Vector transmission model}
\usage{
simulate_vectortransmission_ode(Sh = 1000, Ih = 1, Rh = 0,
  Sv = 1000, Iv = 1, b1 = 0.002, b2 = 0.002, g = 1, w = 0.1,
  m = 100, n = 0.1, tstart = 0, tfinal = 100, dt = 0.1)
}
\arguments{
\item{Sh}{: starting value for Susceptible hosts : numeric}

\item{Ih}{: starting value for Infected hosts : numeric}

\item{Rh}{: starting value for Recovered hosts : numeric}

\item{Sv}{: starting value for Susceptible Vectors : numeric}

\item{Iv}{: starting value for Infected Vectors : numeric}

\item{b1}{: infection rate of hosts : numeric}

\item{b2}{: infection rate of vectors : numeric}

\item{g}{: recovery rate of hosts : numeric}

\item{w}{: wanning immunity rate : numeric}

\item{m}{: vector birth rate : numeric}

\item{n}{: vector death rate : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic model with several compartments to model vector-borne transmission
}
\details{
The model tracks the dynamics of susceptible, infected, and recovered hosts, and susceptible and infected vectors. Infection, recovery, and waning immunity processes are implemented for hosts. Births and deaths and infection processes are implemented for vectors.
This code is based on a dynamical systems model created by the modelbuilder package.  
The model is implemented here as a set of ordinary differential equations, 
using the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_vectortransmission_ode() 
}
