% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_vectortransmission.R
\name{simulate_vectortransmission}
\alias{simulate_vectortransmission}
\title{Simulation of a compartmental infectious disease transmission model illustrating vector-borne transmission}
\usage{
simulate_vectortransmission(Sh0 = 1000, Ih0 = 1, Sv0 = 0, Iv0 = 0,
  tmax = 120, b1 = 0.01, b2 = 0, m = 0, n = 0, g = 1, w = 0)
}
\arguments{
\item{Sh0}{initial number of susceptible hosts}

\item{Ih0}{initial number of infected hosts}

\item{Sv0}{initial number of susceptible vectors}

\item{Iv0}{initial number of infected vectors}

\item{tmax}{maximum simulation time, units of months}

\item{b1}{rate of transmission from infected vector to susceptible host}

\item{b2}{rate of transmission from infected host to susceptible vector}

\item{m}{the rate of births of vectors}

\item{n}{the rate of natural death of vectors}

\item{g}{the rate at which infected hosts recover/die}

\item{w}{the rate at which host immunity wanes}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
This model allows for the simulation of a vector-borne infectious disease
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The compartments are Sh, Ih, Rh, and Sv, Iv.
  The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_vectortransmission()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_vectortransmission(Sh0 = 100, Sv0 = 1e5,  tmax = 100)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[ , "Time"],result$ts[ , "Sh"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See the information in the corresponding Shiny app for model details.
           See the documentation for the deSolve package for details on ODE solvers.
}
\seealso{
The UI of the Shiny app 'VectorTransmission', which is part of this package, contains more details on the model.
}
\author{
Andreas Handel
}
