% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_directtransmission.R
\name{simulate_directtransmission}
\alias{simulate_directtransmission}
\title{Simulation of a compartmental infectious disease transmission model illustrating different types of direct transmission}
\usage{
simulate_directtransmission(PopSize = 1000, I0 = 1, tmax = 120,
  scenario = 1, bd = 0.01, bf = 0, A = 1, b = 0, n = 0, g = 0.1,
  w = 0)
}
\arguments{
\item{PopSize}{initial population size}

\item{I0}{initial number of infected hosts}

\item{tmax}{maximum simulation time, units of months}

\item{scenario}{choice between density dependent (=1) and frequency dependent (=2) transmission scenarios}

\item{bd}{rate of transmission for density-dependent transmission}

\item{bf}{rate of transmission for frequency-dependent transmission}

\item{A}{the size of the area in which the hosts are assumed to reside/interact}

\item{b}{the rate of births}

\item{n}{the rate of natural deaths}

\item{g}{the rate at which infected hosts recover}

\item{w}{the rate of waning immunity}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver
}
\description{
This model allows for the simulation of different direct transmission modes
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message
}

\examples{
  # To run the simulation with default parameters just call this function
  result <- simulate_directtransmission()
  # To choose parameter values other than the standard one, specify them e.g. like such
  result <- simulate_directtransmission(PopSize = 100,   tmax = 100, A=10)
  # You should then use the simulation result returned from the function, e.g. like this:
  plot(result[,1],result[,2],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the shiny app 'DirectTransmission', which is part of this package, contains more details on the model
}
\author{
Andreas Handel
}
