## ----, echo=TRUE---------------------------------------------------------
library(DNAprofiles)
dist <- list(x=1:6,fx=rep(1/6,6))
dists <- replicate(n = 10,expr = dist,simplify = FALSE)

## ----, echo=TRUE---------------------------------------------------------
exact.q(t = 100,dists = dists)

## ------------------------------------------------------------------------
data(freqsNLngm)
x <- profiles(list(D1S1656="12/15",D2S441="11/14",D2S1338="19/19",D3S1358="16/18",FGA="22/24",D8S1179="11/12",
              D10S1248="13/14",TH01="7/9",VWA="16/17",D12S391="17/20",D16S539="12/13",D18S51="13/17",
              D19S433="13/14",D21S11="27/31.2",D22S1045="15/16"),
        labels = get.labels(freqs = freqsNLngm))


## ------------------------------------------------------------------------
un <- ki.dist(x,hyp.1 = "FS",hyp.2 = "UN",hyp.true = "UN",freqs.ki = freqsNLngm)

## ------------------------------------------------------------------------
un$D2S1338
un$D3S1358

## ------------------------------------------------------------------------
un.cdf <- dist.pair.cdf(dists.product.pair(un))
1-un.cdf(500)

## ------------------------------------------------------------------------
fs.cdf <-  ki.cdf(x,hyp.1 = "FS",hyp.2 = "UN",hyp.true = "FS",freqs.ki = freqsNLngm) # shorthand
1-fs.cdf(500)

## ------------------------------------------------------------------------
data(freqsNLsgmplus)
hp <- ki.dist(hyp.1 = "PO",hyp.2 = "UN",hyp.true = "PO",freqs.ki = freqsNLsgmplus)
hd <- ki.dist(hyp.1 = "PO",hyp.2 = "UN",hyp.true = "UN",freqs.ki = freqsNLsgmplus)

## ------------------------------------------------------------------------
n0 <- sapply(hp, function(d) length(d$x)) 
n0
prod(n0)

## ------------------------------------------------------------------------
sim.q(t = 1e4,dists = hp,N = 1e6)

## ------------------------------------------------------------------------
sim.q(t = 1e4,dists = hd,N = 1e6)

## ------------------------------------------------------------------------
sim.q(t = 1e6,dists = hd,N = 1e6)

## ------------------------------------------------------------------------
sim.q(t = 1e4,dists = hd,dists.sample = hp,N = 1e6)

## ------------------------------------------------------------------------
sim.q(t = 1e6,dists = hd,dists.sample = hp,N = 1e6)

